# Description

YM Fast SEO enhances your website with powerful, intuitive, and easy-to-use SEO tools. In today’s digital world, SEO is essential for driving organic traffic and improving your website’s visibility on search engines.

With YM Fast SEO, you can easily manage important aspects of search optimization without unnecessary complexity. Unlike bulky alternatives, this lightweight plugin is efficient, flexible, and easy to extend, allowing you to keep full control over your website’s performance.

## Features

* Lightweight & Extendable
* Fields for Posts and Taxonomies Meta Tags
* Automated Open Graph, Twitter Card, and Schema.org Markups
* Automatic IndexNow Sending
* Quick SEO Analysis and Site SEO Health Page
* Services Integration (Analytics + Webmasters)
* SVG Favicon Support
* `Robots.txt` Editor
* Other Useful Tools & Improvement

# Changelog

## 4.0.0
* New: Wide support for SVG site icons. If you use an SVG site icon (requires a [third-party plugin](https://wordpress.org/plugins/search/SVG/)), it will now be rendered according to modern web standards
* Fix: SEO check with enabled unnecessary title parts

## 3.4.1
* New: [`ymfseo_{$taxonomy}_taxonomy_tags`](https://yanmet.com/blog/ym-fast-seo-wordpress-plugin-documentation#ymfseo_taxonomy_tags) filter that allows you to create custom tags for taxonomy

## 3.4.0
* New: [`ymfseo_{$post_type}_posts_tags`](https://yanmet.com/blog/ym-fast-seo-wordpress-plugin-documentation#ymfseo_post_type_tags) filter that allows you to create custom tags for post types
* Fix: WooCommerce SEO column

## 3.3.3
* Fix: Open Graph/Twitter Cards canonical URL
* Fix: IndexNow sending for noindex taxonomies
* Fix: Posts auto descriptions length

## 3.3.2
* Fix: Text fields sanitizing does not remove custom tags now

## 3.3.1
* New: Post meta fields placeholders
* Fix: Fatal error `Uncaught TypeError: YMFSEO_Meta_Fields` on taxonomy pages

## 3.3.0
* New: Splitting the settings page into tabs
* New: Ability to use shortcodes in meta fields
* New: `%tagline%` tag and [`ymfseo_tags`](https://yanmet.com/blog/ym-fast-seo-wordpress-plugin-documentation#ymfseo_tags) filter
* Fix: Settings page design

## 3.2.8
* New: `Representative's Image` media state
* Fix: Now `noindex` taxonomies are not displayed in sitemaps

## 3.2.7
* New: Taxonomy default `Indexing` settings option
* New: Default terms Title & Description values in placeholders
* Fix: Quick edit SEO fields

## 3.2.6
* New: `Preview Image` media state
* Fix: Gutenberg meta box style

## 3.2.4
* New: Quick edit SEO fields
* Fix: Editor Role capabilities

## 3.2.3
* Fix: Now `noindex` pages are not displayed in sitemaps

## 3.2.0
* New: Settings page UI
* New: Admin Bar menu
* New: `IndexNow Sending` option
* Fix: WordPress 6.7.0 `get_plugin_data()`
* Fix: IndexNow sending logic

## 3.1.3
* New: [`ymfseo_title_separator`](https://yanmet.com/blog/ym-fast-seo-wordpress-plugin-documentation#ymfseo_title_separator) filter
* Fix: Terms pages now have the `CollectionPage` type as default
* Fix: Limit resending URL to IndexNow within 10 minutes

## 3.1.2
* Fix: Fatal error on plugin activation due to `add_cap()` function

## 3.1.1
* Fix: Activation/Deactivation hook
* Fix: Roles capabilities

## 3.1.0
* New: `Head Scripts` editor
* New: `Hide Users Sitemap` option
* New: `<link rel="next">` tag for pagination pages
* Fix: User page meta tags
* Fix: Multisite `robots.txt` edit
* Fix: Representative image
* Fix: IndexNow
* Fix: Empty IndexNow table on the Site SEO Health page
* Fix: Settings page design

## 3.0.0
* New: IndexNow system
* New: Site SEO Health page
* New: Logs system
* New: Representative organization types

## 2.2.1
* New: `Clear Excerpts` option
* New: Additional `Save` settings page button
* New: Version of the current theme now appends to the preview image URL

## 2.2.0
* New: Length check for taxonomy meta fields
* New: `Online Store` organization type
* New: Representative `Phone`, `City`, `Address`, `Region`, `Postal Code`, `Image` options
* Fix: Taxonomy meta fields security

## 2.1.0
* New: Taxonomy meta fields
* New: SEO Editor role and capabilities
* New: Bing Webmaster Tools integration
* Fix: JSON-LD escaping

## 2.0.1
* Fix: Multisite sitemaps in `robots.txt`
* Fix: Multisite `robots.txt` edit
* Fix: UTF-8 symbols counting in Basic SEO checks

## 2.0.0
* New: Settings page design
* New: `Post Types` and `Taxonomies` settings blocks
* New: `Representative` settings block
* Fix: Performance optimization
* Fix: Database space optimization

## 1.2.1
* Fix: Schema.org encoding
* Fix: Undefined `$preview_image_uri`
* Fix: Translations

## 1.2.0
* New: `Page Type` meta field
* New: `Clear Titles`, `Title Separator`, `Preview Image` settings options
* New: Ability to disallow indexing for individual pages/posts
* New: Webmaster services integrations
* Fix: Meta fields caching
* Fix: `robots.txt` editor

## 1.1.0
* New: `robots.txt` editor
* New: Basic SEO checks
* New: Meta fields length indicator
* Fix: `robots` meta tag

## 1.0.0
* Initial release